<?php $__env->startSection('title','Admin | New Release Version'); ?>
<?php $__env->startSection('landlord-content'); ?>

<?php echo $__env->make('includes.session_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php if(isset($versionUpgradeData['alert_version_upgrade_enable']) &&
        $versionUpgradeData['alert_version_upgrade_enable'] == true): ?>
    <!-- For New Version -->
    <section id="newVersionSection" class="container mt-5 text-center">
        <div class="card">
            <div class="card-body">
                <h4 class="text-center text-success"> A new version <b><?php echo e($versionUpgradeData['demo_version']); ?></b> has
                    been released.</h4>
                <p>Before upgrading, we highly recomended you to keep a backup of your current script and database.</p>
            </div>
        </div>

        <div class="d-flex justify-content-center mt-3 mb-3">
            <div id="spinner" class="d-none spinner-border text-success" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <form action="<?php echo e(route('version-upgrade')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <button type="submit" class="mt-5 mb-5 btn btn-primary btn-lg">Upgrade</button>
        </form>
    </section>
<?php else: ?>
    <!-- Cuurent Version -->
    <section id="oldVersionSection" class="container mt-5 text-center">
        <div class="card">
            <div class="card-body">
                <h4 class="text-center text-info">Your current version is <span><?php echo e(env('VERSION')); ?></span></h4>
                <p>Please wait for upcoming version</p>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $("#upgrade-form").on("submit", function() {
        $(".upgrade-btn").prop("disabled", true);
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('landlord.super-admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\peopleprosaas\resources\views/version_upgrade/index.blade.php ENDPATH**/ ?>