<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class JobPost extends Model
{
	protected $guarded=[];

	public function Company(){
		return $this->hasOne('App\Models\company','id','company_id');
	}

	public function PostJobCategory(){
		return $this->hasOne('App\Models\JobCategory','id','job_category_id');
	}

	public function jobExperience(){
		return $this->hasOne('App\Models\JobExperience','id','job_experience_id');
	}



	public function getRouteKeyName()
	{
		return 'job_url'; // TODO: Change the autogenerated stub
	}

	public function setClosingDateAttribute($value)
	{
		$this->attributes['closing_date'] = Carbon::createFromFormat(env('Date_Format'), $value)->format('Y-m-d');
	}

	public function getClosingDateAttribute($value)
	{
		return Carbon::parse($value)->format(env('Date_Format'));
	}

	public function getCreatedAtAttribute($value)
	{
		return Carbon::parse($value)->format(env('Date_Format'));
	}

}
